'
' Base class for classes that visit objects that make up a 
' document and manipulate them.
'
Friend MustInherit Class DocumentVisitor
    ' The document that this object is manipulating
    Private myDocument As Document

    ' This index used to navigate children
    ' of document.
    Private docIndex As Integer = 0

    ' Constructor
    ' document - The Document to be visited
    Friend Sub New(ByVal document As Document)
        myDocument = document
    End Sub

    ' The document that this object is manipulating
    Protected ReadOnly Property Document() As Document
        Get
            Return myDocument
        End Get
    End Property

    ' The next paragraph that is a direct part of the document
    ' being manipulated or Nothing if there is no next paragraph
    Protected ReadOnly Property NextParagraph() As Paragraph
        Get
            Dim myDocument As Document = Document
            While docIndex < myDocument.Count
                Dim docElement As IDocumentElement
                docElement = myDocument.GetChild(docIndex)
                docIndex += 1
                If TypeOf docElement Is Paragraph Then
                    Return CType(docElement, Paragraph)
                End If
            End While
            Return Nothing
        End Get
    End Property
End Class 'DocumentVisitor 
